<?php
require "config.php";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">


    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">
    <!-- App title -->
    <title>Tiger SD</title>

    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/core.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/components.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/icons.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/pages.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/menu.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/responsive.css" rel="stylesheet" type="text/css" />

    <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

    <script src="assets/js/modernizr.min.js"></script>

</head>


<body class="fixed-left">
    <?php include_once('include/header.php'); ?>
    <div class="page-title-box">
        <h4 class="page-title">Create Hosting </h4>
        <ol class="breadcrumb p-0 m-0">
            <li>
                <a href="#">Tiger SD</a>
            </li>

            <li class="active">
                Create Hosting
            </li>
        </ol>
        <div class="clearfix"></div>
    </div>
    </div>
    </div>
    <!-- end row -->

    <form method="POST" action="">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="">Domain Name</label>
                    <input type="text" class="form-control" id="" placeholder="Enter Domain Name" name="domain_name">
                </div>

                <div class="form-group">
                    <label for="">Email</label>
                    <input type="text" class="form-control" id="" placeholder="Enter Email" name="email">
                </div>
                <div class="form-group">
                    <label for="">Plan</label>
                    <select class="form-control" id="" name="plan">
                        <option>Select A Plan</option>
                        <option>Plan-A 500/year</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="">Amount</label>
                    <input type="text" class="form-control" id="" placeholder="Enter Amount" name="amount">
                </div>
                <div class="form-group">
                    <label for="">Payment</label>
                    <div class="radio">
                        <input type="radio" name="payment" id="paytm" value="UPI">
                        <label for="paytm">
                            Through UPI
                        </label>
                    </div>
                    <div class="radio">
                        <input type="radio" name="payment" id="bt" value="banktransfer">
                        <label for="bt">
                            Bank Transfer
                        </label>
                    </div>
                </div>
                <div class="form-group">
                    <!-- <span id="qr_code"></span> -->
                    <img src="assets/images/qrcode.png" id="qr_code" style="display: none">
                </div>

                <div class="form-group bank_details">
                    <p class="m-b-0">A/c No:<span id="sp1"></span></p>
                    <p class="m-b-0">A/c Name:<span id="sp2"></span></p>
                    <p class="m-b-0">IFSC Code:<span id="sp3"></span></p>
                    <p class="m-b-0">Branch Code:<span id="sp4"></span></p>
                    <p class="m-b-0">Bank Name:<span id="sp5"></span></p>

                </div>

                <div class="form-group">
                    <label for="">Referance No.</label>
                    <input type="text" class="form-control" placeholder="Enter Bank Reference Number" name="bank_reference">
                </div>


                <button type="submit" class="btn btn-primary waves-effect waves-light" name="submit">Submit</button>
    </form>
    </div>
    </div>

    <?php include_once('include/footer.php'); ?>



    <script>
        var resizefunc = [];
    </script>

    <!-- jQuery  -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/detect.js"></script>
    <script src="assets/js/fastclick.js"></script>
    <script src="assets/js/jquery.blockUI.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/jquery.slimscroll.js"></script>
    <script src="assets/js/jquery.scrollTo.min.js"></script>
    <script src="../plugins/switchery/switchery.min.js"></script>

    <!-- App js -->
    <script src="assets/js/jquery.core.js"></script>
    <script src="assets/js/jquery.app.js"></script>

    <script>
        $(".radio input[type='radio']").on('click', function() {
            if ($("#paytm").is(":checked")) {
                $("#qr_code").css("display","block");
                $("#qr_code").html("show update");
                $(".bank_details").css("display","none");
            } else if ($("#bt").is(":checked")) {
                $(".bank_details").css("display","block");
                $("#sp1").html("5641XXXXXXXXXXXXXXX");
                $("#sp2").html("Abhishekhar Gundeti ");
                $("#sp3").html("ICIC001234");
                $("#sp4").html("X X X X X X X");
                $("#sp5").html("ICICI Bank of India");
                $("#qr_code").css("display","none");

            }
        });
    </script>


    <!-- PHP SCript -->
    <?php
    if (isset($_POST['submit'])) {
        $domain_name = mysqli_real_escape_string($connect,$_POST['domain_name']);
        $email = mysqli_real_escape_string($connect,$_POST['email']);
        $plan = mysqli_real_escape_string($connect,$_POST['plan']);
        $amount =mysqli_real_escape_string($connect,$_POST['amount']);
        $payment_type =mysqli_real_escape_string($connect,$_POST['payment']);
        $bank_reference = mysqli_real_escape_string($connect,$_POST['bank_reference']);

        $query = "INSERT INTO myhostings(domain_name, email, plan, amount, payment_type, reference_no) VALUES
         ('$domain_name','$email','$plan','$amount','$payment_type','$bank_reference')";
        $exec = mysqli_query($connect, $query) or mysqli_error($conn);
        if ($exec) {
            echo "<script>alert('Server created succesfully')</script>";
        } else {
            echo "<script>alert('Internal Error')</script>";
        }
    }
    ?>


</body>

</html>