<?php
require "config.php";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">


    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">
    <!-- App title -->
    <title>Tiger SD</title>

    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/core.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/components.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/icons.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/pages.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/menu.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/responsive.css" rel="stylesheet" type="text/css" />

    <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

    <script src="assets/js/modernizr.min.js"></script>

</head>


<body class="fixed-left">
    <?php include_once('include/header.php'); ?>
    <div class="page-title-box">
        <h4 class="page-title">My Hostings </h4>
        <ol class="breadcrumb p-0 m-0">
            <li>
                <a href="#">Tiger SD</a>
            </li>

            <li class="active">
                My Hostings
            </li>
        </ol>
        <div class="clearfix"></div>
    </div>
    </div>
    </div>
    <!-- end row -->
    <!-- PHP Scripts -->

    <div class="table-responsive">
        <table class="table table-bordered m-0">

            <thead>
                <tr>
                    <th>#</th>
                    <th>Domain Name</th>
                    <th>Email</th>
                    <th>Create Date</th>
                    <th>Plan</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $query = "SELECT * FROM myhostings";
            $select = mysqli_query($connect, $query);
            if (mysqli_num_rows($select)) {
                while ($table_data = mysqli_fetch_assoc($select)) {
                    $status=$table_data['status'];
                    $d=$table_data['created_on'];
                    $date=date('d/m/y h:i:s A',strtotime($d));
                    
                    switch($status){
                        case "A":
                            $status="<span class='text-success'>Active</span>";
                        break;
                        case "P":
                            $status="<span class='text-warning'>Pending</span>";
                        break;
                        case "D":
                            $status="<span class='text-danger'>Denied</span>";
                        break;
                        default:
                            $status="<span class='text-dark'>No Status Available</span>";
                    break;
                }
           ?>
                    <!-- End PHP Scripts -->

                    
                        <tr>
                            <th scope="row"><?php echo $table_data['id']; ?></th>
                            <td><?php echo $table_data['domain_name']; ?></td>
                            <td><?php echo $table_data['email']; ?></td>
                            <td><?php echo $date; ?></td>
                            <td><?php echo $table_data['plan']; ?></td>
                            <td><?php echo $status;?></td>
                        </tr>
                        <?php
    }
}
?>
                    </tbody>
        </table>
    </div>

<?php include_once('include/footer.php'); ?>



<script>
    var resizefunc = [];
</script>

<!-- jQuery  -->
<script src="assets/js/jquery.min.js"></script>
<script src="assets/js/bootstrap.min.js"></script>
<script src="assets/js/detect.js"></script>
<script src="assets/js/fastclick.js"></script>
<script src="assets/js/jquery.blockUI.js"></script>
<script src="assets/js/waves.js"></script>
<script src="assets/js/jquery.slimscroll.js"></script>
<script src="assets/js/jquery.scrollTo.min.js"></script>
<script src="../plugins/switchery/switchery.min.js"></script>

<!-- App js -->
<script src="assets/js/jquery.core.js"></script>
<script src="assets/js/jquery.app.js"></script>

</body>

</html>